function DataSetPlotNoise(DataSet, net, MarkerSize, N, Var, colors);

% add N Gaussian distributed vectors to each input vector, assuming the class does not change.
% DS - data set
% net - network from Netlab
% N - number of noise points to be added to each data point
%

% Add noise to DataSet.Inputs
% Noise Variance: multiply randn by Var

Ninp=size(DataSet.Inputs);
Nrow=Ninp(1);
Ncol =Ninp(2);
Nccol=size(DataSet.Desired);
Nclass=Nccol(2);

%  Ncol = # input samples, Nclass = # classes = target values
% for each vector DataSet.Input(k,:) add N new ones

%N1=N+1;
onen1=ones(N,1);
zeros1=zeros(1,Ncol);
nxt =[] ; 	%  nxt and nyt are empty 
nyt= [] ;

% Plot only the noise here, not data points!
%
for k=1:Nrow
%for k=40:58	
%if (k==432 | k==1553 | k==2670 | k==483 | k==1620 ) 
 noise = Var*randn(N,Ncol);
 nxt=[nxt;noise+onen1*DataSet.Inputs(k,:)];
 nyt=[nyt;onen1*DataSet.Desired(k,:)];  	% vector with desired (target) class labels
%end
end
   
   switch net.type 
      	case 'rbf'
%		   net = rbftrain(net, net.options, nxt, nyt);
   	   	   [DataSet.Outputs,g,n2] = rbffwd(net,nxt);
	case 'mlp'
%		   [net, options] = netopt(net, net.options, nxt, nyt, 'scg');
		   DataSet.Outputs = mlpfwd(net, nxt); 
%
		otherwise
		   error('not supported type of net'); 
   end

% Plot the data in 2D

DataSetPlot(DataSet.Outputs, nyt, MarkerSize, colors);

disp([' Total number of points plotted= ' num2str(size(nxt))])

CheckErrors(DataSet.Outputs, nyt);
