% Artificial 5 class data
clear
clc, clf

iInput = 4;
iHidden = 5;
iOut = 5;
Nnoisepoints=10;  	% add some noise
VarNoise=0.5;		% with this variance

DS = DataSetLoad('..\data\adata_5class.dat',iInput );
%DataSet.Inputs = Normdata(DataSet.Inputs);

net = rbf(iInput, iHidden, iOut, 'gaussian');
options = foptions;
%options(1) = 1;		% Display EM training
options(14) = 200;	   % number of iterations of EM (default 100)
net.options = options;

%CrossValidation(DataSet,net, 10)
[xt, yt] = DataSetSplit(DS, 66);
net = rbftrain(net, net.options, xt, yt);

[DS.Outputs,g,n2] = rbffwd(net,DS.Inputs);
[e, p] = CheckErrors(DS.Outputs, DS.Desired)

PlotNoise(DS, net, Nnoisepoints, VarNoise)

return

% See where outliers end up ... 

N = 1;
p = GaussMultiDimPoints( [-7,0,0,0], 0.2, N);
[y_out,g,n2] = rbffwd(net,p);
[W B] = Projection2D(5);
y = (W*(y_out)')' + ones(N,1)*B';
plot(y(:,1), y(:,2), 'ok');



