% look at projected data
clf
MarkerSize=10;

a=0.4;

Da=[0 	0 	0 ;
	0      0 	1 ;
	0      1 	0 ;
	0      1 	1 ;
	1      0 	0 ;
	1      0 	1 ;
	1   	1 	0 ;
	a   	1 	a ;
	1      1 	1];

Dc=[1 0 0 
	0 1 0 ;
	0 0 1 ;
	1 0 0 ;
	0 1 0 ;
	0 0 1 ;
	1 0 0 ;
	1 0 0 ;
	0 1 0 ];

[N,C] = size(Dc);

% Specify colors and marker types
colors = [ '+r'; 'og'; 'xb'; '.m'; '.c'];

   [W, B] = Projection2D(C);   
   y_2D = (W * (Da'))' + ones(N,1)*B';

for i=1:N
   for c=1:C
      if Dc(i,c) == 1
         break
      end
   end

axis([-0.2 1.2 -0.5 1.2])
plot(y_2D(i,1),y_2D(i,2), colors(c,:), 'MarkerSize', MarkerSize);
hold on
end

