//---------------------------------------------------------------------------
#pragma hdrstop

#if !defined (__mStringH)
	#include "mString.h"
#endif

//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
inline void mString::preparemString(const int x)
    {
    len=0;
    good=0;
    contens=0;
    blok=x;
    hm_blok=0;
    }
//---------------------------------------------------------------------------
inline void mString::preparemString(const int x,const int y)
    {
    good=0;
    if (x>0)
        blok=x;
    else
        blok=BLOK;
    if (y>0)
        len=y;
    else
        len=0;
    hm_blok=hm_bloks();
    contens=hm_ram(hm_blok*blok);
    }
//---------------------------------------------------------------------------
inline void mString::charCopy(const char* sors,char* dest)
    {
    if (sors!=0 && dest!=0)
      {
        int i;
        for (i=0;sors[i]!=0;i++)
            dest[i]=sors[i];
        dest[i]=0;
      }
    else
        {
        delete[] dest;
        dest=0;
        }
    }
//---------------------------------------------------------------------------
void mString::deletemString(void)
    {
    if (good==0 && contens!=0 && len<=blok*hm_blok && hm_blok<10000)
        {
        delete[] contens;
        contens=0;
        good=-1;
        }
    }
//---------------------------------------------------------------------------
inline const int mString::hm_bloks(void) const
    {
    int y=0;
    if (blok!=0)
        {
        y=len/blok;
        float reszta=((float)len/((float)blok))-(float)y;
        if (reszta>0) y++;
        }
    return y;
    }
//---------------------------------------------------------------------------
inline const int mString::get_len(const char* x) const
    {
    int i=0;
    while (x[i]) i++;
    i++;
    return i;
    }

//---------------------------------------------------------------------------
const int mString::get_len(void) const
    {
    return len;
    }
//---------------------------------------------------------------------------
inline char* mString::hm_ram(const int x) const
    {
    char *str=0;
    if (x>0)
      {
      try
          {
          str=new char[x];
          }
      catch (std::bad_alloc)
          {
          exit(-1);
          }
      }
    return str;
    }
//---------------------------------------------------------------------------
inline void mString::ReturnBad(void)
    {
    const char *str=BAD;
    int llen=get_len(BAD);
    preparemString(llen,llen);
    charCopy(str,contens);
    }
//---------------------------------------------------------------------------
inline bool mString::isCipher(const char x)const
    {
    int xx=(int)x;
    if (xx==46) return true;
    if (xx==45) return true;
    // if (xx==44) res=true; //Czy to potrzebne ?
    if (xx>=48 && xx<=57) return true;
    return false;
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//Publiczne skladowe
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
mString::mString(void)
    {
    preparemString(0);
    }
//---------------------------------------------------------------------------
mString::~mString(void)
    {
    deletemString();
    }
//---------------------------------------------------------------------------
mString::mString(const char* x,const int y)
    {
    int llen=get_len(x);
    if (y>0)
          {
          preparemString(y,llen);
          }
    else
        preparemString(llen+5,llen);
    charCopy(x,contens);
    }
//---------------------------------------------------------------------------
mString::mString(const int x,const int y)
    {
    char *str=hm_ram(50);
    itoa(x, str, 10);
    preparemString(y,get_len(str));
    charCopy(str,contens);
    delete[] str;
    }
//---------------------------------------------------------------------------
mString::mString(const float x,const int y)
    {
    char *str=hm_ram(y);
    gcvt( x , 5 , str);
    preparemString(y,get_len(str));
    charCopy(str,contens);
    delete[] str;
    }
//---------------------------------------------------------------------------
mString::mString(const double x,const int ndec,const int y)
    {
    char *str=hm_ram(y);
    gcvt( x , ndec , str);
    preparemString(y,get_len(str));
    charCopy(str,contens);
    delete[] str;
    }
//---------------------------------------------------------------------------
mString::mString(const mString &x)
    {
    if (x.good==0)
        {
        if (*this!=x)
          {
          deletemString();
          preparemString(x.blok,x.len);
          charCopy(x.contens,contens);
          }
        }
    else
        {
        ReturnBad();
        }
    }
//---------------------------------------------------------------------------
mString& mString::operator=(const mString& x)
    {
    if (x.good==0)
        {
        if (this->good==0 && *this!=x)
            {
            if (x.len<=this->blok*this->hm_blok)
                {
                charCopy(x.contens,contens);
                len=x.len;
                }
            else
                {
                deletemString();
                preparemString(x.blok,x.len);
                charCopy(x.contens,contens);
                }
            }
        }
    else
        {
        ReturnBad();
        }
    return *this;
    }
//---------------------------------------------------------------------------
mString& mString::operator=(const char* x)
    {
    mString res(x,get_len(x)+1);
    return (*this=res);
    }
//---------------------------------------------------------------------------
mString& mString::operator=(const float x)
    {
    mString res(x);
    return *this=res;
    }
//---------------------------------------------------------------------------
mString& mString::operator=(const double x)
    {
    int ndec,blok;
    if (x>100000000)
        {
        blok=10;
        ndec=15;
        }
    else if (x>1000000)
        {
        blok=5;
        ndec=10;
        }
    else
        {
        blok=2;
        ndec=8;
        }
    mString res(x,ndec,blok*BLOK);
    return *this=res;
    }
//---------------------------------------------------------------------------
mString& mString::operator=(const int x)
    {
    mString res(x);
    return *this=res;
    }
//---------------------------------------------------------------------------
mString& mString::operator+(const mString& x)
    {
    if (x.good==0)
        {
        if (x.contens==0) return *this;
        if (x.len+len<=blok*hm_blok)
            {
            int j=0;
            for (int i=len-1;x.contens[j]!=0;i++)
                {
                contens[i]=x.contens[j];
                j++;
                }
            len=x.len+len-1;
            contens[len-1]=0;
            }
        else
            {
            mString res(*this);
            deletemString();
            preparemString(blok,res.len+x.len-1);
            charCopy(res.contens,contens);
            int j=0;
            for (int i=res.len-1;i<len;i++)
                {
                contens[i]=x.contens[j];
                j++;
                }
            contens[len-1]=0;
            }
        }
    else
        {
        ReturnBad();
        }
    return *this;
    }
//---------------------------------------------------------------------------
mString& mString::operator+(const int x)
    {
    mString res(x);
    if (this->len>1)
        return ((*this)+res);
    else
        return (*this=res);
    }
//---------------------------------------------------------------------------
mString& mString::operator+(const float x)
    {
    mString res(x);
    if (this->len>1)
        return ((*this)+res);
    else
        return (*this=res);
    }
//---------------------------------------------------------------------------
mString& mString::operator+(const char* x)
    {
    mString res(x,get_len(x)+1);
    if (this->len>1)
        return ((*this)+res);
    else
        return (*this=res);
    }
//---------------------------------------------------------------------------
mString& mString::operator-(const char* x)
    {
     if (good==0)
      {
      if (x==0) return *this;
      int res=find(x);
      int llen=get_len(x)-1;
      int k=res;
      if (res!=-1)
          {
          while(res!=-1)
              {
              int ras=find(x,res+llen);
              for (int j=res+llen;j<len;j++)
                  {
                  if (j==ras)
                      break;
                  contens[k]=contens[j];
                  k++;
                  }
              res=find(x,res+llen);
              }
          }
      len=k;
      contens[len-1]=0;
      }
    else
      {
      ReturnBad();
      }
    return *this;
    }
//---------------------------------------------------------------------------
mString& mString::operator-(const mString& x)
    {
    if (x.len<this->len)
        return (*this-(const char*)x);
    else
        return *this;
    }
//---------------------------------------------------------------------------
mString::operator const char*(void)const
    {
    if (contens!=0 && len!=0)
        return this->contens;
    else
        return "Ten mString jest pusty!";
    }
//---------------------------------------------------------------------------
mString::operator float(void) const
    {
    char *store=new char[len];
    int k=0;
    for (int i=0;i<len;i++)
        {
        if (isCipher(contens[i]))
            {
            store[k]=contens[i];
            k++;
            if (isCipher(contens[i+1])==false)
                break;
            }
        }
    store[k]=0;
    float res=(float)atof(store);
    delete[] store;
    return res;
    }
//---------------------------------------------------------------------------
const bool mString::operator==(const mString& x)const
    {
    bool result=true;
    if (x.good!=0 || this->good!=0) return false;
    //if (x.blok!=this->blok) return false;
    //if (x.hm_blok!=this->hm_blok) return false;
    if (x.len!=this->len) return false;
    for (int i=0;i<x.len;i++)
        {
        if (this->contens[i]!=x.contens[i])
            {
            result=false;
            break;
            }
        }
    return result;
    }
//---------------------------------------------------------------------------
const bool mString::operator==(const char* x)const
    {
    mString store(x,blok);
    if (store==(*this))
        return true;
    else
        return false;
    }
//---------------------------------------------------------------------------
const bool mString::operator!=(const mString& x)const
    {
    if (*this==x)
        return false;
    else
        return true;
    }
//---------------------------------------------------------------------------
const bool mString::operator!=(const char* x)const
    {
    if ((*this)==x)
        return false;
    else
        return true;
    }
//---------------------------------------------------------------------------
int mString::find(const char* x,const int y) const
    {
    int wynik=-1;
    int ly;
    if (y<0 || y>len)ly=0;
    else ly=y;
    if (good==0) for (int i=ly;i<len;i++)
        {
        if (x[0]==contens[i])
            {
            bool f1=true;
            int j=0;
            while(x[j]!=0)
                {
                if(x[j]!=contens[i+j])
                    {
                    f1=false;
                    break;
                    }
                else
                    j++;
                }
            if (f1==true)
                {
                wynik=i;
                break;
                }
            }
        }
    return wynik;
    }
//---------------------------------------------------------------------------
int mString::find(const char* x,const int y,const int z) const
    {
    int wynik=-1;
    int ly,lz;
    if (y<0 || y>len)ly=0;
    else ly=y;
    if (z<0 || z>len) lz=len;
    else lz=z;
    if (good==0) for (int i=ly;i<lz;i++)
        {
        if (x[0]==contens[i])
            {
            bool f1=true;
            int j=0;
            while(x[j]!=0)
                {
                if(x[j]!=contens[i+j])
                    {
                    f1=false;
                    break;
                    }
                else
                    j++;
                }
            if (f1==true)
                {
                wynik=i;
                break;
                }
            }
        }
    return wynik;
    }
//---------------------------------------------------------------------------
int mString::find(const mString& x,const int y,const int z) const
    {
    return find((const char*)x,y,z);
    }
//---------------------------------------------------------------------------
int mString::find(const mString& x,const int y) const
    {
    int res=-1;
    if (x.len<len)
        {
        res=find((const char*)x,y);
        }
    return res;
    }
//---------------------------------------------------------------------------
int* mString::find_all(const char* x)const
    {
    int xlen=(len+(len/2))/get_len(x)+1;
    if (xlen<2) xlen=2;
    int *res=new int[xlen];
    res[0]=0;
    res[1]=find(x,0);
    if (res[1]!=-1)
      {
      int i=2;
      int llen=get_len(x)-1;
      res[0]=res[0]+1;
      for(;;)
          {
          res[i]=find(x,res[i-1]+llen);
          if (res[i]==-1)
            break;
          else
            {
            i++;
            res[0]=res[0]+1;
            }
          }
      }
    return res;
    }
//---------------------------------------------------------------------------
int* mString::find_all(const mString& x) const
    {
    return this->find_all((const char*)x);
    }
//---------------------------------------------------------------------------
void mString::insert(const char* x,const int yy)
    {
    if (good==0 && x!=0)
        {
        int y;
        int llen=get_len(x)-1;
        if (yy==-1) y=len-1;
        else y=yy;
        if (len+llen<blok*hm_blok)
            {
            char* store=new char[llen];
            int k=0;
            for (int i=y;i<y+llen;i++)
                {
                store[k]=contens[i];
                contens[i]=x[k];
                k++;
                }
            contens[len+llen-1]=0;
            for(int i=len+llen-1;i>=y+2*llen;i--)
                {
                contens[i]=contens[i-llen];
                }
            k=0;
            for (int i=y+llen;i<y+2*llen;i++)
                {
                contens[i]=store[k];
                k++;
                }
            len=len+llen;    
            delete[] store;
            }
        else
            {
            int slen=len+llen;
            mString res;
            if (contens!=0)
                {
                res=(*this);
                deletemString();
                preparemString(blok,slen);
                }
            else
                preparemString(llen,slen);

            int j=0,k=0;
            for (int i=0;i<len;i++)
              {
              if (i<y || i>=y+llen)
                  {
                  contens[i]=res.contens[j];
                  j++;
                  }
              else
                  {
                  contens[i]=x[k];
                  k++;
                  }
              }

            }
        }
    else
        ReturnBad();
    }
//---------------------------------------------------------------------------
void mString::insert(const mString& x,const int yy)
    {
    this->insert((const char*)x,yy);
    }
//---------------------------------------------------------------------------
void mString::del(const char* x,const int y)
    {
    if (good==0)
      {
      int yy;
      if (y<0) yy=0;
      else yy=y;
      int res=find(x,yy);
      int llen=get_len(x)-1;
      int k=res;
      if (res!=-1)
          {
          for (int j=res+llen;j<len;j++)
              {
              contens[k]=contens[j];
              k++;
              }
          }
      len=k;
      contens[len-1]=0;
      }
    else
      {
      ReturnBad();
      }
    }
//---------------------------------------------------------------------------
void mString::del(const mString& x,const int y)
    {
    this->del((const char*)x,y);
    }
//---------------------------------------------------------------------------
void mString::del(const int x,const int y)
    {
    if (good==0)
      {
      int xx,yy;
      if (x<0 || x>=len) xx=0;
      else xx=x;
      if (y<=0 || y>=len) yy=len-1;
      else yy=y;
      if (yy<xx)
          {
          yy=xx+yy;
          if (yy>=len)yy=len-1;
          }
      if (xx!=yy)
        {
        int k=xx;
        for (int i=yy;i<len;i++)
            {
            contens[k]=contens[i];
            k++;
            }
        len=len-(yy-xx);
        }
      }
    else
      ReturnBad();
    }
//---------------------------------------------------------------------------
void mString::cut(const int x, const int y, char* res) const
    {
    if (good==0)
        {
        int xx,yy;
        if (x<0 || x>=len) xx=0;
        else xx=x;
        if (y<0 || y>=len) yy=len-1;
        else yy=y;
        int k=0;
        if (x<=y)
            {
            for (int i=xx;i<=yy;i++)
                {
                res[k]=contens[i];
                k++;
                }
            res[k]=0;
            }
        else
            {
            int i;
            for(i=0;BAD[i]!=0;i++)
                res[i]=BAD[i];
            res[i]=0;
            }
        }
    else
        {
        int i;
        for(i=0;BAD[i]!=0;i++)
            res[i]=BAD[i];
        res[i]=0;
        }
    }
//---------------------------------------------------------------------------
void mString::cut(const int x, const int y, mString& res) const
    {
    int xx,yy;
    if (x<0 || x>=len) xx=0;
    else xx=x;
    if (y<=0 || y>=len) yy=len-1;
    else yy=y;
    int siz=yy-xx;
    siz=siz+5;
    if (siz<=6) siz=10;
    char* store=new char[siz];
    this->cut(xx,yy,store);
    res=store;
    delete[] store;
    }
//---------------------------------------------------------------------------
char* mString::cut(const int x, const int y) const
    {
    int xx,yy;
    if (x<0 || x>=len) xx=0;
    else xx=x;
    if (y<=0 || y>=len) yy=len-1;
    else yy=y;
    /*
    if (yy<xx)
        {
        yy=xx+yy;
        if (yy>=len)yy=len-1;
        }
    */
    char* res=new char[yy-xx+2];

    if (good==0)
        {
        int k=0;
        for (int i=xx;i<=yy;i++)
            {
            res[k]=contens[i];
            k++;
            }
        res[k]=0;
        }
    else
        {
        int i;
        for(i=0;BAD[i]!=0;i++)
            res[i]=BAD[i];
        res[i]=0;
        }
    return res;
    }
//---------------------------------------------------------------------------
float* mString::toFloat(void)const
    {
    char* store=new char[len+10];
    char* store2=new char[255];
    int j=0;
    for (int i=0;i<len;i++)
        {
        if (isCipher(contens[i]))
            {
            store[j]=contens[i];
            j++;
            if(isCipher(contens[i+1])==false)
                {
                store[j]=' ';
                j++;
                }
            }
        }
    store[j]=0;
    mString rob(store);
    int *hm=rob.find_all(" ");
    float *res=new float[hm[0]+2];
    int x=0;
    res[0]=(float)(hm[0]);
    for(int i=0;i<hm[0];i++)
        {
        int j=hm[i+1];
        rob.cut(x,j-1,store2);
        x=j+1;
        res[i+1]=atof(store2);
        }
    res[hm[0]+1]=-1;
    delete[] hm;
    delete[] store;
    delete[] store2;
    return res;
    }
//---------------------------------------------------------------------------
void mString::replace(const char* sors,const char* dest)
    {
    int sorsLen=get_len(sors)-1;
    int destLen=get_len(dest)-1;
    int *res=find_all(sors);
    if (res[0]>0)
      {
      mString result("\0",len-sorsLen*res[0]+
        destLen*res[0]);
      int j=0,jj=1;
      int llen=0;
      for (int i=0;i<len;i++)
        {
        if (i<res[jj] || res[jj]==-1)
            {
            result.contens[j]=contens[i];
            j++;
            llen++;
            }
        else if (i==res[jj])
            {
            int n=0;
            for (int k=i;k<destLen+i;k++)
                {
                result.contens[j]=dest[n];
                n++;
                j++;
                llen++;
                }
            jj++;
            i=i+sorsLen-1;
            }
        }
       result.len=llen;
      (*this)=result;
      }
    delete[] res;
    }
//---------------------------------------------------------------------------
void mString::removeDoubles(const mString& x)
    {
    mString lx(x);
    lx+x;
    replace((const char*)lx,(const char*)x);
    }
//---------------------------------------------------------------------------

