%  Use NETLAB to create network and do calculations
clear
clc;clf

nin = 36;			% Number of inputs.
nout = 5;			% Number of outputs.

nhidden = 30;		% Number of hidden units.
alpha     = 0.05;	% Coefficient of weight-decay prior. 

Nnoisepoints=0;  	% add some noise
VarNoise=0.01;	% with this variance

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

DS = DataSetLoad('..\data\satim5.dat',nin);
disp('Loaded: SatImage5 data')  
disp([' nin= ' num2str(nin) ' nout = ' num2str(nout)])
disp([' Input size= ' num2str(size(DS.Inputs)) ]) 

DS.Inputs = Normdata(DS.Inputs);
				%			
net = mlp(nin, nhidden, nout, 'logistic', alpha);
options = zeros(1,18);
options(1) = 1;				% This provides display of error values.
options(2) = 0.001;			% Termination criterion.
options(3) = 0.001;			% Termination criterion for error functions.
options(14) = 1500;		% Number of training cycles; converges slowly ... 

% options(17) = 0.4;		% Momentum. 

%	Split data to train and test - but test on all? 
[xt, yt] = DataSetSplit(DS, 100);
disp([' Train set size= ' num2str(size(xt)) ]) 

%  Optimize network, on train data [xt, yt], with SCG method
disp([' Train epochs= ' num2str(options(14)) ',  Regularization a=' num2str(alpha)]) 

[net, options] = netopt(net, options, xt, yt, 'scg');
net.options = options;

DS.Outputs = mlpfwd(net, DS.Inputs);

[e, p] = CheckErrors(DS.Outputs, DS.Desired);

% Plot data and noise, define marker sizes and colors
PlotNoise(DS, net, Nnoisepoints, VarNoise)
