using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using Intemi;

namespace TutorialPrg
{
    class ProgramExpl
    {
        static void Main(string[] args)
        {
            Project project = null;
            try
            {
                project = new Project(new LocalTaskMgr());
                project.LoadAssembly("TutorialPrg");

                TimeSpan begin = Process.GetCurrentProcess().UserProcessorTime;
                DateTime dtB = DateTime.Now;

                //TutorialExpl.MDMissingGen1Test(project);
                TutorialExpl.MDBasic1Test(project);

                Console.WriteLine();
                //TutorialExpl.MDBasicClass1Test(project);
                //TutorialExpl.MDkNN1Test(project);
                //TutorialExpl.MDEM1Test(project);
                //TutorialExpl.MDDA1Test(project);

                //TutorialExpl.DataPrint(project);
                //TutorialExpl.DataPrint2(project);

                //TutorialExpl.MachineTest(project);
                //TutorialExpl.MachineTest2aMajority(project);

                //TutorialExpl.MachineTest3Box(project);
                //TutorialExpl.MachineTest3BoxB(project);
                //TutorialExpl.MachineTest3BoxC(project);
                //TutorialExpl.MachineTest3BoxInBox(project);

                //TutorialExpl.MachineTest_Repeater(project);
                //TutorialExpl.MachineTest_CV(project);
                //TutorialExpl.MachineTest_CV2(project);
                //TutorialExpl.MachineTest_CVwithResultsExplorer(project);
                //TutorialExpl.MachineTest_CV_Of_TransAndClass(project);
                //TutorialExpl.MachineTestFeatSel(project);
                //TutorialExpl.MachineTest_CV_Of_RankingFS_And_Class(project);
                //TutorialExpl.DiscretizerTest(project);

                //TutorialExpl.Repeater_CV_with_KNN_and_NB(project);
                //TutorialExpl.McNemar_Of_single_KNN_and_NB(project);
                //TutorialExpl.McNemar_from_CV_with_KNN_and_NB(project);
                //TutorialExpl.Repeater_MannWhitney_and_Wilcoxon(project);

                //TutorialExpl.MachineTest_SSVDT(project);
                
                //TutorialExpl.ShowAvailableMachines(project, true, true);

                project.Close();

                TimeSpan end = Process.GetCurrentProcess().UserProcessorTime;
                DateTime dtE = DateTime.Now;
                Console.WriteLine("  Time consumed (proc/real): {0} s / {1} s",
                    (double)((end.Ticks - begin.Ticks) / 10000) / 1000,
                    (double)(dtE.Subtract(dtB).Ticks / 10000) / 1000);
            }
            catch (Exception e)
            {
                Console.WriteLine("Exception: " + e.Message);
                if (project != null)
                    project.Close();
            }
        }
    }

}
