#ifndef _PROC_H_
#define _PROC_H_

#include <math>
#include "matrix.h"
#include "file_class.h"

class Procrust
  {
  private:
  DataFile *Testee;
  DataFile *Target;
  DataFile *Destination;

  inline const double MAX(const double &a, const double &b)
        {return b > a ? (b) : (a);}
  inline const double MIN(const double &a, const double &b)
        {return b < a ? (b) : (a);}
  inline const double SIGN(const double &a, const double &b)
	{return b >= 0 ? (a >= 0 ? a : -a) : (a >= 0 ? -a : a);}

  //twierdzenie pitagorasa
  double pythag(const double a, const double b);
  //dekompozycja singularna
  void svdcmp(Matrix &a, Matrix &w, Matrix &v);

  void proc(const Matrix & Y, const Matrix & X, Matrix & YtoX);
  //centruje macierz
  Matrix center_matrix(const Matrix & m);
  //symuluje macierz centrujaca o zadanej liczbie elementow n
  double SimJ(unsigned int n, unsigned int row, unsigned int col);
  void proc_accuracy();

  public:
  AnsiString ProcError;
  double Accuracy;

  Procrust(DataFile &Testee, DataFile &Target, DataFile &Destination);
  ~Procrust();
  double ProcrustesAnalysis();
  //zwraca wskaznik do podpietego pliku
  DataFile * pTestee();
  DataFile * pTarget();
  DataFile * pDestination();
  };

#endif